/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.eui;

import ibm.nways.jdm.JmaColors;
import ibm.nways.jdm.common.NotSupported;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.common.TimeTicks;
import ibm.nways.jdm.eui.JDMInput;
import java.awt.Label;
import java.text.DateFormat;
import java.util.Date;

public class TimeTicksDateRO
extends Label
implements JDMInput {
    private Date date;
    private TimeTicks timeTicks;
    protected boolean hasErrorValue;
    protected boolean ignoreValue;

    public TimeTicksDateRO() {
        this.setForeground(JmaColors.textText);
        this.hasErrorValue = false;
        this.ignoreValue = false;
    }

    public Object getValue() {
        return this.timeTicks;
    }

    public void setValue(Object object) {
        this.hasErrorValue = false;
        this.ignoreValue = false;
        if (object instanceof TimeTicks || object instanceof Integer) {
            this.timeTicks = object instanceof Integer ? new TimeTicks(((Integer)object).longValue()) : (TimeTicks)object;
            this.date = new Date(this.timeTicks.value);
            String string = DateFormat.getDateTimeInstance(1, 1).format(this.date);
            this.setText(string);
        } else if (object instanceof SpecialValue) {
            SpecialValue specialValue = (SpecialValue)object;
            this.setText(specialValue.toString());
            this.hasErrorValue = true;
            if (object instanceof NotSupported) {
                this.ignoreValue = true;
            }
        } else {
            this.setText(object.toString());
        }
        this.invalidate();
    }

    public void setValue(String string) {
        TimeTicks timeTicks = new TimeTicks(0L);
        timeTicks.fromString(string);
        this.setValue(timeTicks);
    }

    public boolean isValidValue() {
        return !this.hasErrorValue;
    }

    public boolean ignoreValue() {
        return this.ignoreValue;
    }
}

